/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.services.LogService;
import de.willuhn.jameica.services.SysPropertyService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Properties;

public class SysinfoService
implements Bootable {
    public Class[] depends() {
        return new Class[]{LogService.class, SysPropertyService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        try {
            Logger.info((String)("starting Jameica Version " + Application.getManifest().getVersion()));
        }
        catch (Exception e) {
            Logger.warn((String)"unable to detect Jameica Version number");
        }
        Logger.info((String)("  Built-Date : " + Application.getBuildDate()));
        Logger.info((String)("  Buildnumber: " + Application.getBuildnumber()));
        Logger.info((String)("  max. memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "mb"));
        Logger.info((String)("  sys charset: " + Charset.defaultCharset().name()));
        Logger.info((String)"command line parameters");
        String[] args = Application.getStartupParams().getParams();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Logger.info((String)("  [" + args[i] + "]"));
            }
        } else {
            Logger.info((String)"  none");
        }
        if (Logger.isLogging((Level)Level.DEBUG)) {
            Properties p = System.getProperties();
            Enumeration<Object> e = p.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Logger.debug((String)(key + ": " + p.getProperty(key)));
            }
        } else {
            Logger.info((String)("os.arch          : " + System.getProperty("os.arch")));
            Logger.info((String)("os.name          : " + System.getProperty("os.name")));
            Logger.info((String)("os.version       : " + System.getProperty("os.version")));
            Logger.info((String)("java.version     : " + System.getProperty("java.version")));
            Logger.info((String)("java.vendor      : " + System.getProperty("java.vendor")));
            Logger.info((String)("java.runtime.name: " + System.getProperty("java.runtime.name")));
            Logger.info((String)("java.vm.name     : " + System.getProperty("java.vm.name")));
            Logger.info((String)("user.name        : " + System.getProperty("user.name")));
            Logger.info((String)("user.home        : " + System.getProperty("user.home")));
            Logger.info((String)("file.encoding    : " + System.getProperty("file.encoding")));
        }
    }

    public void shutdown() {
    }
}

